#!/bin/bash
# history_stats.sh - Analyze command usage from history

echo "Command Usage Statistics"
echo "========================"
echo ""

echo "Top 20 Most Used Commands:"
echo "--------------------------"
history | awk '{print $2}' | sort | uniq -c | sort -rn | head -20 | \
    awk '{printf "%3d  %s\n", $1, $2}'

echo ""
echo "Command Categories:"
echo "-------------------"

# Git commands
git_count=$(history | grep -c "^[[:space:]]*[0-9]*[[:space:]]*git")
echo "Git commands: $git_count"

# File operations
file_count=$(history | grep -cE "^[[:space:]]*[0-9]*[[:space:]]*(cp|mv|rm|mkdir|touch)")
echo "File operations: $file_count"

# Navigation
nav_count=$(history | grep -cE "^[[:space:]]*[0-9]*[[:space:]]*(cd|ls|pwd)")
echo "Navigation: $nav_count"

# Editing
edit_count=$(history | grep -cE "^[[:space:]]*[0-9]*[[:space:]]*(vim|nano|emacs|code)")
echo "Text editing: $edit_count"

echo ""
echo "History Statistics:"
echo "-------------------"
total_commands=$(history | wc -l)
echo "Total commands: $total_commands"

unique_commands=$(history | awk '{print $2}' | sort -u | wc -l)
echo "Unique commands: $unique_commands"

echo ""
echo "Recent Activity (Last 10 commands):"
echo "------------------------------------"
history | tail -10
