#!/bin/bash
# backup_history.sh - Backup Bash history file

# Configuration
HISTORY_FILE="$HOME/.bash_history"
BACKUP_DIR="$HOME/.bash_history_backups"
DATE=$(date +%Y%m%d_%H%M%S)
BACKUP_FILE="$BACKUP_DIR/bash_history_$DATE"
KEEP_DAYS=30

# Create backup directory
mkdir -p "$BACKUP_DIR"

# Backup history file
if [ -f "$HISTORY_FILE" ]; then
    cp "$HISTORY_FILE" "$BACKUP_FILE"
    echo "✓ History backed up to: $BACKUP_FILE"
    
    # Compress backup
    gzip "$BACKUP_FILE"
    echo "✓ Compressed: ${BACKUP_FILE}.gz"
else
    echo "✗ History file not found: $HISTORY_FILE"
    exit 1
fi

# Clean old backups
echo ""
echo "Cleaning backups older than $KEEP_DAYS days..."
find "$BACKUP_DIR" -name "bash_history_*.gz" -mtime +$KEEP_DAYS -delete
echo "✓ Cleanup complete"

# Show backup statistics
echo ""
echo "Backup Statistics:"
echo "------------------"
echo "Total backups: $(ls -1 "$BACKUP_DIR" | wc -l)"
echo "Total size: $(du -sh "$BACKUP_DIR" | cut -f1)"
echo ""
echo "Recent backups:"
ls -lht "$BACKUP_DIR" | head -6
