#!/bin/bash
# batch_rename.sh - Batch rename files with prefix

# Configuration
PREFIX="processed_"
EXTENSION="*.jpg"

echo "Batch Rename Script"
echo "==================="
echo "Adding prefix: $PREFIX"
echo "File pattern: $EXTENSION"
echo ""

# Dry run first
echo "DRY RUN - Files that would be renamed:"
for file in $EXTENSION
do
    [ -e "$file" ] || continue
    newname="${PREFIX}${file}"
    echo "  $file -> $newname"
done

echo ""
read -p "Proceed with rename? (y/n): " confirm

if [ "$confirm" = "y" ] || [ "$confirm" = "Y" ]; then
    for file in $EXTENSION
    do
        [ -e "$file" ] || continue
        newname="${PREFIX}${file}"
        mv "$file" "$newname"
        echo "Renamed: $file -> $newname"
    done
    echo "Rename complete!"
else
    echo "Rename cancelled."
fi
