#!/bin/bash
# backup_script.sh - Backup multiple directories

# Configuration
BACKUP_DIR="/tmp/backups"
DATE=$(date +%Y%m%d_%H%M%S)

# Directories to backup
DIRS_TO_BACKUP=(
    "$HOME/Documents"
    "$HOME/Pictures"
    "$HOME/Projects"
)

echo "Backup Script"
echo "============="
echo "Backup location: $BACKUP_DIR"
echo "Timestamp: $DATE"
echo ""

# Create backup directory
mkdir -p "$BACKUP_DIR"

# Backup each directory
for dir in "${DIRS_TO_BACKUP[@]}"
do
    if [ -d "$dir" ]; then
        dirname=$(basename "$dir")
        backup_file="$BACKUP_DIR/${dirname}_${DATE}.tar.gz"
        
        echo "Backing up: $dir"
        tar -czf "$backup_file" "$dir" 2>/dev/null
        
        if [ $? -eq 0 ]; then
            size=$(du -h "$backup_file" | cut -f1)
            echo "  ✓ Created: $backup_file ($size)"
        else
            echo "  ✗ Failed to backup $dir"
        fi
    else
        echo "  ⚠ Skipping $dir (not found)"
    fi
    echo ""
done

echo "Backup complete!"
