# For Loop Examples - README

This package contains sample Bash scripts demonstrating various for loop patterns.

## Files Included

1. **basic_loop.sh** - Simple for loop examples
   - List iteration
   - Number ranges
   - C-style loops
   - Array iteration

2. **file_processor.sh** - Process files in a directory
   - Usage: `./file_processor.sh <directory>`
   - Counts lines and words in .txt files

3. **batch_rename.sh** - Batch rename files
   - Adds prefix to files
   - Includes dry-run preview
   - Requires confirmation

4. **backup_script.sh** - Backup multiple directories
   - Creates timestamped tar.gz archives
   - Configurable backup locations

## Usage

1. Make scripts executable:
   ```bash
   chmod +x *.sh
   ```

2. Run any script:
   ```bash
   ./basic_loop.sh
   ./file_processor.sh /path/to/directory
   ./batch_rename.sh
   ./backup_script.sh
   ```

## Customization

Edit the scripts to:
- Change file patterns (*.txt, *.jpg, etc.)
- Modify prefixes and suffixes
- Add your own processing logic
- Adjust backup locations

## Learn More

Visit: https://yourdomain.com/docs/bash-zsh/for-loops/
